#!/bin/bash
#Copyright 9c) 2010 cpremote.net 
RED='\033[01;31m'
GREEN='\033[01;32m'
RESET='\033[0m'
export REMOTEIP=$(/bin/grep 'SSHSERVIP' /etc/cpremote/cpbackup.conf  |cut -d ':' -f2 )
export REMOTEPRT=$(/bin/grep 'SSHSERPRT' /etc/cpremote/cpbackup.conf  |cut -d ':' -f2 )
export REMOTEUSR=$(/bin/grep 'SSHBKPUSR' /etc/cpremote/cpbackup.conf  |cut -d ':' -f2 )
export DESTFLDR=$(/bin/grep 'SSHUSRHOM' /etc/cpremote/cpbackup.conf  |cut -d ':' -f2 )
export LOCALSDIR=$(/bin/grep 'LOCALSDIR' /etc/cpremote/cpbackup.conf  |cut -d ':' -f2 )

for CPUSER in `/bin/ls /etc/cpremote/clean/`
do
	echo -ne "Removing cPremote   Remote Backups ..."
	ssh -F /etc/cpremote/ssh_config $REMOTEUSR@$REMOTEIP -p $REMOTEPRT rm -rf $DESTFLDR/*/$CPUSER &
	echo -e "[ $GREEN DONE  $RESET ]"
	echo -ne "Removing cPremote  Local Backups ..."
	rm -rf $LOCALSDIR/*/$CPUSER &
	echo -e "[ $GREEN DONE  $RESET ]"
done
rm -rf /etc/cpremote/clean/*
rm -rf /var/log/cpremote.*
