#!/bin/bash
#Copyright (c) 2008-2013 http://syslint.com/ 
RED='\033[01;31m'
GREEN='\033[01;32m'
RESET='\033[0m'
RED='\033[01;31m'
GREEN='\033[01;32m'
RESET='\033[0m'
clear
echo -e "$GREEN*************************************************************$RESET"
echo -e "          cPremote Installation Wizard"
echo -e "          Copyright (c) 2008-2013  http://syslint.com/"
echo -e "$GREEN*************************************************************$RESET"
echo " "
echo " "
echo -ne "Checking for Previous installation .."
# Upgrade start
if [ -e  "/etc/cpremote/cpbackup.conf" ]; then
	echo -e "[ $GREEN FOUND $RESET ]"
	echo -ne "Checking for  .. CPPHP"

	if [ -e '/usr/local/cpanel/3rdparty/php/53/bin/php' ];then
		export PHP_BIN="/usr/local/cpanel/3rdparty/php/53/bin/php"
        	echo -e "[ $GREEN YES $RESET ]"
	elif [ -e '/usr/local/cpanel/3rdparty/bin/php' ];then
		export PHP_BIN="/usr/local/cpanel/3rdparty/bin/php"
        	echo -e "[ $GREEN YES $RESET ]"
	else
		echo -e "[ $RED NO $RESET ]"
		exit
	fi

	echo -ne "Checking for Ioncube Loader..."
	if $PHP_BIN -v | grep 'ionCube' > /dev/null ;then
        	echo -e "[ $GREEN YES $RESET ]"
	else
		echo -e "[ $RED NO $RESET ]"
		echo -e "$RED ioncube Loader is not enabled in CPPHP. Please enable ioncube Loader from WHM -> Teaksettings $RESET";
        	exit

	fi

sh upgrade_from_old.sh
echo " upgrade completed "
exit	
fi
# End of upgrade

if [ -e  "/usr/local/cpanel/version" ]; then
	echo -e "[ $GREEN YES $RESET ]"
else
	echo -e "[ $RED No $RESET ]"
	exit
fi

echo -ne "Checking for previous installation .."

echo -ne "Checking for SSH .."
if [ -e  "/usr/bin/ssh" ]; then
	echo -e "[ $GREEN YES $RESET ]"
else
	echo -e "[ $RED No $RESET ]"
	exit
fi
echo -ne "Checking for RSYNC .."
if [ -e  "/usr/bin/rsync" ]; then
	echo -e "[ $GREEN YES $RESET ]"
else
	echo -e "[ $RED No $RESET ]"
	exit
fi
echo -ne "Checking for SED .."
if [ -e  "/bin/sed" ]; then
	echo -e "[ $GREEN YES $RESET ]"
else
	echo -e "[ $RED No $RESET ]"
	exit
fi
echo -ne "Checking for GREP .."
if [ -e  "/bin/grep" ]; then
	echo -e "[ $GREEN YES $RESET ]"
else
	echo -e "[ $RED No $RESET ]"
	exit
fi

echo -ne "Checking for  ..  CPHP"
if [ -e '/usr/local/cpanel/3rdparty/php/53/bin/php' ];then
	export PHP_BIN="/usr/local/cpanel/3rdparty/php/53/bin/php"
	echo -e "[ $GREEN YES $RESET ]"
elif [ -e '/usr/local/cpanel/3rdparty/bin/php' ];then
	export PHP_BIN="/usr/local/cpanel/3rdparty/bin/php"
	echo -e "[ $GREEN YES $RESET ]"
else
	export PHP_BIN="/var/cpanel/3rdparty/bin/php"
	echo -e "[ $RED NO $RESET ]"
	echo -e "$RED I can't find  CPPHP  . install CPPHP $RESET";
        exit
fi



echo -ne "Disabling cPanel default Backup options .."
	sed -i 's/BACKUPENABLE.*/BACKUPENABLE no/g'  /etc/cpbackup.conf
	echo -e "[ $GREEN YES $RESET ]"

echo -ne "Checking for Ioncube Loader..."

if $PHP_BIN -v | grep 'ionCube' > /dev/null ;then
       echo -e "[ $GREEN YES $RESET ]"
else
        echo -e "[ $RED NO $RESET ]"
        echo -e "$RED ioncube Loader is not enabled in CPPHP. Please enable ioncube Loader from WHM -> Tweaksettings $RESET";
        exit

fi

echo -ne "Checking for Yum .."
if [ -e  "/etc/yum.conf" ]; then
	echo -e "[ $GREEN YES $RESET ]"
	yum -y install mailx
else
	echo -e "[ $RED No $RESET ]"
	exit
fi

echo -ne "Installing cPremote Plugin..."
	chown root.root cgi/* -R
	chown root.root etc/* -R
	chown root.root scripts/* -R
	chown root.root cpanel/* -R
	chmod 700 cgi/addon_cPremote.cgi
	cp -arf cgi/* 	/usr/local/cpanel/whostmgr/docroot/cgi/
	if [ -e "/usr/local/cpanel/bin/register_appconfig" ]; then
                if [ ! -d "/var/cpanel/apps" ]; then
                        mkdir /var/cpanel/apps
                	chmod 755 /var/cpanel/apps
                fi
                /usr/local/cpanel/bin/register_appconfig /usr/local/cpanel/whostmgr/docroot/cgi/cpremote/cpremote.conf
                /bin/rm -f /usr/local/cpanel/whostmgr/docroot/cgi/addon_cPremote.cgi
        else
                chmod -v 700 /usr/local/cpanel/whostmgr/docroot/cgi/addon_cPremote.cgi
                if [ -e "/usr/local/cpanel/3rdparty/bin/perl" ]; then
                        sed -i 's/#\!\/usr\/bin\/perl/#\!\/usr\/local\/cpanel\/3rdparty\/bin\/perl/g' /usr/local/cpanel/whostmgr/docroot/cgi/addon_cPremote.cgi
                fi
        fi
	cp -arf etc/* /etc/
	ssh-keygen -t rsa -f /etc/cpremote/id_rsa -N ""
	chmod 700 scripts/*
	cp -arf scripts/*  /usr/local/cpanel/scripts/
	cp -v cpremotebackupmanager.cpanelplugin /usr/local/cpanel/bin/
	/usr/local/cpanel/bin/register_cpanelplugin /usr/local/cpanel/bin/cpremotebackupmanager.cpanelplugin
	/usr/local/cpanel/bin/rebuild_sprites
	for i in `find /usr/local/cpanel/base/frontend/  -maxdepth 1 -type d | egrep -v '/usr/local/cpanel/base/frontend/$'`
	do
		cp -rf cpanel/cpremote $i/
	done
	
	echo -e "[ $GREEN done $RESET ]"	
echo -ne "Installing backup cron .."
	cat cron.root >> /var/spool/cron/root
	echo -e "[ $GREEN done $RESET ]"
# install update cron
if [ -e "/usr/local/cpanel/3rdparty/bin/perl" ]; then
	sed -i 's/#\!\/usr\/bin\/perl/#\!\/usr\/local\/cpanel\/3rdparty\/bin\/perl/g' /usr/local/cpanel/whostmgr/docroot/cgi/addon_cPremote.cgi
fi

echo -ne "Checking for autoupdate cron"
if [ -e "/etc/cron.weekly/updatecpremote.sh" ] ; then

	echo -e "[ $GREEN YES $RESET ]"
else
	echo -e "[ $RED No $RESET ]"
	cp -v  updatecpremote.sh  /etc/cron.weekly/
	chmod 700 /etc/cron.weekly/updatecpremote.sh
fi

# Setup weekly clean cron

cp -v clearcpremote.sh /etc/cron.weekly/
chmod 750 /etc/cron.weekly/clearcpremote.sh

# Installing cpulimit
echo -ne "Checking for cpulimit"
if [ -e "/usr/sbin/cpulimit" ] ; then
	echo -e "[ $GREEN YES $RESET ]"
else
	echo -e "[ $RED No $RESET ]"
	echo "Installing cpulimit"
	wget -c http://files.syslint.com/src/cpulimit-1.1.tar.gz
	tar -xzf cpulimit-1.1.tar.gz
	cd cpulimit-1.1/
	make
	cp -af cpulimit /usr/sbin/
	cd ..
	rm -rf cpulimit*
fi
# Install rsync 3.0
echo -ne "Checking for Rsync 3.0 ............."

if [ -e  "/opt/rsync/bin/rsync" ]; then
        echo -e "[ $GREEN YES $RESET ]"

else
        echo -e "[ $RED No $RESET ]"
        echo "Installing Rsync 3.0...."
        wget -c  http://files.syslint.com/src/rsync-3.0.9.tar.gz
        tar -xzf  rsync-3.0.9.tar.gz
        cd rsync-3.0.9/
        ./configure  --prefix=/opt/rsync
        make
        make install
	cd ..
	rm -rf rsync*
fi

echo -e "--------------------------------------------------------------------------------------"
echo -e "				Installation Completed"
echo -e "	Please configure your backup from WHM->Plugins->cPanel Remote Backup"
echo -e "--------------------------------------------------------------------------------------"
